<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Career extends Model
{
    use HasFactory;

    protected $fillable = [
        'job_title',
        'location',
        'salary',
        'experience',
        'slug',
        'qualification',
        'job_desc',
        'status'
    ];

    // Scope to get only active careers
    public function scopeActive($query)
    {
        return $query->where('status', 1);
    }

    // Relationship with job applications
    public function jobApplications()
    {
        return $this->hasMany(JobApplication::class, 'job_id');
    }
}
