<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Service extends Model
{
    protected $fillable = [
        'title',
        'slug',
        'short_desc',
        'long_desc',
        'img',
        'status'
    ];

    // Scope to get only active services
    public function scopeActive($query)
    {
        return $query->where('status', 1);
    }

    // Get the full image URL
    public function getImageUrlAttribute()
    {
        if ($this->img) {
            // If it's already a full URL, return as is
            if (filter_var($this->img, FILTER_VALIDATE_URL)) {
                return $this->img;
            }
            // Otherwise, prepend the frontend assets path
            return '/frontend/assets/images/services/' . $this->img;
        }
        // Default image if none provided
        return '/frontend/assets/images/services/default-service.jpg';
    }
}
