<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Sale;

class SalesTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $sales = [
            [
                'title' => 'HVAC System Installation - 30% OFF',
                'slug' => 'hvac-system-installation-30-off',
                'short_desc' => 'Professional HVAC installation with energy-efficient systems. Complete setup with 2-year warranty and maintenance package included.',
                'long_desc' => '<h4>Special HVAC Installation Offer</h4><p>Get professional HVAC system installation at an unbeatable price. Our certified technicians ensure optimal performance and energy efficiency.</p><h4>What\'s Included</h4><ul><li>Complete system installation</li><li>Energy efficiency optimization</li><li>2-year warranty</li><li>Free maintenance for 6 months</li></ul>',
                'img' => 'sales/hvac-installation.jpg',
                'status' => 1,
            ],
            [
                'title' => 'Fire Safety System Package - 25% OFF',
                'slug' => 'fire-safety-system-package-25-off',
                'short_desc' => 'Comprehensive fire safety solutions including detection, suppression, and emergency systems. Professional installation and certification.',
                'long_desc' => '<h4>Complete Fire Safety Package</h4><p>Protect your property with our comprehensive fire safety systems. Includes detection, suppression, and emergency response systems.</p><h4>Package Features</h4><ul><li>Fire detection systems</li><li>Suppression equipment</li><li>Emergency lighting</li><li>Professional certification</li></ul>',
                'img' => 'sales/fire-safety-package.jpg',
                'status' => 1,
            ],
            [
                'title' => 'MEP Engineering Consultation - 40% OFF',
                'slug' => 'mep-engineering-consultation-40-off',
                'short_desc' => 'Expert MEP engineering consultation for your projects. Comprehensive planning, design, and implementation guidance from certified engineers.',
                'long_desc' => '<h4>Professional MEP Consultation</h4><p>Get expert guidance on your MEP projects from our certified engineers. Comprehensive planning and design services.</p><h4>Consultation Includes</h4><ul><li>Project assessment</li><li>Design recommendations</li><li>Cost optimization</li><li>Implementation planning</li></ul>',
                'img' => 'sales/mep-consultation.jpg',
                'status' => 1,
            ],
            [
                'title' => 'Smart Building Automation - 35% OFF',
                'slug' => 'smart-building-automation-35-off',
                'short_desc' => 'Transform your building with intelligent automation systems. Energy management, security integration, and remote monitoring capabilities.',
                'long_desc' => '<h4>Smart Building Solutions</h4><p>Upgrade to intelligent building automation with our comprehensive smart systems. Control lighting, HVAC, security, and more from a single platform.</p><h4>Features</h4><ul><li>Automated lighting control</li><li>HVAC optimization</li><li>Security integration</li><li>Remote monitoring</li></ul>',
                'img' => 'sales/smart-automation.jpg',
                'status' => 1,
            ],
            [
                'title' => 'Emergency Power Systems - 20% OFF',
                'slug' => 'emergency-power-systems-20-off',
                'short_desc' => 'Reliable emergency power solutions including generators, UPS systems, and backup power infrastructure for uninterrupted operations.',
                'long_desc' => '<h4>Emergency Power Solutions</h4><p>Ensure uninterrupted operations with our reliable emergency power systems. Professional installation and maintenance included.</p><h4>System Components</h4><ul><li>Backup generators</li><li>UPS systems</li><li>Power distribution</li><li>Monitoring systems</li></ul>',
                'img' => 'sales/emergency-power.jpg',
                'status' => 1,
            ],
            [
                'title' => 'Energy Audit & Optimization - 50% OFF',
                'slug' => 'energy-audit-optimization-50-off',
                'short_desc' => 'Comprehensive energy audit with optimization recommendations. Identify savings opportunities and improve system efficiency.',
                'long_desc' => '<h4>Energy Efficiency Audit</h4><p>Discover energy savings opportunities with our comprehensive audit service. Get detailed recommendations for system optimization.</p><h4>Audit Includes</h4><ul><li>System performance analysis</li><li>Energy consumption review</li><li>Optimization recommendations</li><li>ROI calculations</li></ul>',
                'img' => 'sales/energy-audit.jpg',
                'status' => 1,
            ],
        ];

        foreach ($sales as $sale) {
            Sale::create($sale);
        }
    }
}
