@extends('voyager::master')
@section('css')
<style>
    .dashboard_widget_card{
    border-radius: 20px;
    border: none;
    box-shadow: 0 0 9px 0px #0000002b;
    display: flex;
    height: calc(100% - 15px);

}
.dashboard_widget_card .card-body{
    padding: 20px;
    width: 100%;
}
.dashboard_widget_card .widget_title{
    color: #6A6464;
}
.dashboard_widget_card.bg-success{
    background-color: #B8E4C980 !important;
}
.dashboard_widget_card.bg-warning{
    background-color: #FAEFD5 !important;
}
.dashboard_widget_card.bg-danger{
    background-color: #F9939480 !important;
}
.dashboard_widget_card.bg-info{
    background-color: #B3E4F580 !important;
}
.dashboard_widget_card.counter_widget .count_value{
    color: #2E83F2;
    margin-bottom: 15px;
    font-weight: bold;
    font-size: 1.5rem;
}
.dashboard_widget_card.counter_widget .counter_text{
    color: #8B8B8B;
    font-size: 0.9rem;
    text-align: center;
}
.dashboard_widget_card.counter_widget[class*=bg-] .count_value{
    color: #000000;
}
.btn{
    border-radius: 30px;
}
.btn-primary{
    background-color: #2E83F2;
    border-color: #2E83F2;
}
.btn-secondary{
    background-color: #C6C2C2;
    border-color: #C6C2C2;
}
.modal-footer{
    border-top: none;
}
.form-group{
    margin-bottom: 1rem;
}
.dashboard_widget_card .filterbtns .btn{
    box-shadow: 0 0 3px 1px #00000000;
    color: #BEBEBE;
    padding: 5px 15px;
    font-size: 12px;
}
.dashboard_widget_card .filterbtns .btn-info{
    background-color: #B3E4F580;
    border-color: #B3E4F580;
    font-weight: bold;
    color: #797979;

}
.dashboard_widget_card .filterbtns .btn-secondary{
    background-color: #EFEDED;
    border-color: #EFEDED;
}
.dashboard_widget_card table thead tr th{
    color: #BBBBBB;
    font-size: 13px;
    font-weight: normal;
}
.dashboard_widget_card table th:not(:first-child),
.dashboard_widget_card table td:not(:first-child){
    text-align: center;
}
.dashboard_widget_card table tbody td{
    color: #000000;
}
.filltericon_btn::after{
    content: "";
    background-image: url('../images/icons/fillterbtn_icon.png');
    display: inline-block;
    width: 25px;
    height: 25px;
    background-position: center;
    background-size: contain;
    background-repeat: no-repeat;
    margin: 0;
}
.filltericon_btn,
.filltericon_btn:hover,
.filltericon_btn:focus,
.filltericon_btn:active{
    display: flex;
    align-items: center;
    margin: 0 10px;
    border: none;
    background-color: transparent;
}
.searchinput.form-group .form-control{
    box-shadow: none;
    background-color: #EDECEC;
    border-radius: 12px;
    border: none;
}
.table>:not(caption)>*>* {
    padding: 0.8rem;
}
.table-striped>thead>tr>th{
    background-color: #E3E1E1;
    color: #7E7E7E;
}
.table-striped>tbody>tr:nth-of-type(odd)>* {
    background-color: #fff;
    --bs-table-accent-bg: #fff;
}
.table-striped>tbody>tr:nth-of-type(even)>* {
    background-color: #F2F4FF;
}
.card.table-responsive{
    border-radius: 20px ;
}
.card{
    border-radius: 20px;
}
label{
    margin-bottom: 5px;
}
</style>
@stop
@section('content')
    <div class="page-content">
        @include('voyager::alerts')
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12">
                    <div class="row">

                    <div class="col-md-4">
                            <div class="card dashboard_widget_card bg-danger">
                                <div class="card-body d-flex flex-column justify-content-between">
                                    <div class="widget_title mb-2"><h3>Product Enquires</h3></div>
                                    <div class="d-flex align-items-center justify-content-between mt-3">
                                      <a href="/admin/product-enquires">
                                            <h2>{{$product_enquires}}</h2>
                                      </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="card dashboard_widget_card bg-success">
                                <div class="card-body d-flex flex-column justify-content-between v-100">
                                    <div class="widget_title mb-2"><h3>Service Enquires</h3></div>
                                    <div class="d-flex align-items-center justify-content-between mt-3">
                                      <a href="/admin/service-enquires">
                                            <h2>{{$service_enquires}}</h2>
                                      </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="card dashboard_widget_card bg-warning">
                                <div class="card-body d-flex flex-column justify-content-between">
                                    <div class="widget_title mb-2"><h3>Enquires</h3></div>
                                    <div class="d-flex align-items-center justify-content-between mt-3">
                                      <a href="/admin/general-enquires">
                                            <h2>{{$enquires}}</h2>
                                      </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>

            </div>

        </div>

    </div>
@stop

@section('javascript')



@stop
