<!DOCTYPE html>
<html lang="{{ config('app.locale') }}" dir="{{ __('voyager::generic.is_rtl') == 'true' ? 'rtl' : 'ltr' }}">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="robots" content="none" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0, minimal-ui">
    <meta name="description" content="admin login">
    <title>@yield('title', 'Admin - '.Voyager::setting("admin.title"))</title>
    <link rel="stylesheet" href="{{ voyager_asset('css/app.css') }}">
    <link rel="stylesheet" href="{{ voyager_asset('css/voyagertheme.css') }}">
    <link rel="shortcut icon" type="image/x-icon" href="/frontend/assets/images/favicon.ico">
    @if (__('voyager::generic.is_rtl') == 'true')
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-rtl/3.4.0/css/bootstrap-rtl.css">
        <link rel="stylesheet" href="{{ voyager_asset('css/rtl.css') }}">
    @endif
    <style>
        body {
            //background-image:url('{{ Voyager::image( Voyager::setting("admin.bg_image"), voyager_asset("images/bg.jpg") ) }}');
            background-color: #3c55ab;
            display:flex;
            align-items: center;
            justify-content: center;
        }
        body.login .login-sidebar {
            border-top:5px solid {{ config('voyager.primary_color','#3c55ab') }};
        }
        @media (max-width: 767px) {
            body.login .login-sidebar {
                border-top:0px !important;
                border-left:5px solid {{ config('voyager.primary_color','#3c55ab') }};
            }
        }
        body.login .form-group-default.focused{
            border-color:{{ config('voyager.primary_color','#3c55ab') }};
        }
        .login-button, .bar:before, .bar:after{
            background:#3c55ab;
        }
        .remember-me-text{
            padding:0 5px;
        }
        body.login .login-button{
            opacity: 1;
        }
        .login_container_card{
            z-index: 1;
            max-width: 400px;
            width: calc(100% - 20px);
            min-height: 300px;
            background-color: #fff;
            border-radius: 15px;
            box-shadow: 0 0 15px 2px #00000021;
            display: flex;
            flex-direction: column;
            padding: 20px;
        }
        .logo_container{
            display: flex;
            align-items:center;
            justify-content: center;
            gap: 10px;
            margin:15px 0;
            color: #000;
            font-weight: bold
        }
        .logo_container .logo_icon img{
            width: 200px;
        }
    </style>

    @yield('pre_css')
</head>
<body class="login">

        {{-- <div class="faded-bg animated"></div> --}}
        {{-- <div class="hidden-xs col-sm-7 col-md-8">
            <div class="clearfix">
                <div class="col-sm-12 col-md-10 col-md-offset-2">
                    <div class="logo-title-container">
                        <?php $admin_logo_img = Voyager::setting('admin.icon_image', ''); ?>
                        @if($admin_logo_img == '')
                            <img class="img-responsive pull-left flip logo hidden-xs animated fadeIn" src="{{ voyager_asset('images/logo-icon-light.png') }}" alt="Logo Icon">
                        @else
                            <img class="img-responsive pull-left flip logo hidden-xs animated fadeIn" src="{{ Voyager::image($admin_logo_img) }}" alt="Logo Icon">
                        @endif
                        <div class="copy animated fadeIn">
                            <h1>{{ Voyager::setting('admin.title', 'Voyager') }}</h1>
                            <p>{{ Voyager::setting('admin.description', __('voyager::login.welcome')) }}</p>
                        </div>
                    </div> <!-- .logo-title-container -->
                </div>
            </div>
        </div> --}}



           @yield('content')


@yield('post_js')
</body>
</html>
