<?php $__env->startSection('content'); ?>
    <!-- ====================================== Sales Hero Section ===================================== -->
    <section class="heroSection">
        <div class="container">
            <h1 class="img-header-text fade_down">Our Sales & Offers</h1>
            <div class="breadcrumb-group fade_up">
                <a href="/">HOME / </a>
                <a href="/sales">Sales</a>
            </div>
        </div>
    </section>

    <!-- ====================================== Sales Section ===================================== -->
    <section class="section-eight testimonial-page">
        <div class="container">


            <div class="row sales-page-row">
                <?php $__empty_1 = true; $__currentLoopData = $sales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sale): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div class="col-xxl-4 col-xl-4 col-lg-4 col-md-6">
                    <div class="cleaning-card sales-card">
                        <div class="cleaning-card-img-main">
                            <img src="<?php echo e(asset('storage/' . $sale->img)); ?>" alt="<?php echo e($sale->title); ?>">

                        </div>
                        
                        <div class="card-containe">
                            <h3 class="services-name"><?php echo e($sale->title); ?></h3>
                            <p class="services-card-sub-text"><?php echo e($sale->short_desc); ?></p>

                            <?php if($sale->original_price && $sale->sale_price): ?>
                            <div class="price-section">
                                <span class="original-price">$<?php echo e($sale->original_price); ?></span>
                                <span class="sale-price">$<?php echo e($sale->sale_price); ?></span>
                                <span class="discount-badge">
                                    <?php echo e(round((($sale->original_price - $sale->sale_price) / $sale->original_price) * 100)); ?>% OFF
                                </span>
                            </div>
                            <?php endif; ?>
                        </div>

                        <a href="/sales_detail/<?php echo e($sale->slug); ?>" class="card-learn-more">
                            View Details
                            <img src="/frontend/assets/images/svg/cross-arrow.svg" alt="cross-arrow">
                        </a>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <div class="col-12">
                    <div class="text-center no-sales-message">
                        <div class="no-sales-icon">
                            <img src="/frontend/assets/images/svg/no-sales.svg" alt="No Sales" style="width: 80px; opacity: 0.5;">
                        </div>
                        <h3>No Sales Available</h3>
                        <p>Check back soon for exciting deals and special offers on our premium cleaning services.</p>
                        <a href="/service" class="btn-quote">
                            View Our Services
                            <img src="/frontend/assets/images/svg/cross-arrow.svg" alt="cross-arrow">
                        </a>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </section>

<style>
/* Sales Page Specific Styling */
.sales-page-row {
    gap: 40px 0;
    margin-top: 50px;
}

.sales-card {
    height: 100%;
    display: flex;
    flex-direction: column;
    position: relative;
    transition: all 0.3s ease;
    box-shadow: 0 5px 20px rgba(0, 0, 0, 0.1);
}

.sales-card:hover {
    transform: translateY(-10px);
    box-shadow: 0 15px 40px rgba(0, 194, 255, 0.2);
}

/* Fixed image sizing for sales cards - standardized */
.sales-page-row .cleaning-card-img-main {
    height: 280px;
    overflow: hidden;
    position: relative;
}

.sales-page-row .cleaning-card-img-main img {
    width: 100%;
    height: 100%;
    object-fit: cover;
    object-position: center;
    border-radius: 20px 20px 0 0;
    transition: transform 0.7s ease;
}

/* Sale badge */
.sale-badge {
    position: absolute;
    top: 15px;
    left: 15px;
    background: linear-gradient(135deg, #FF6B6B 0%, #FF5252 100%);
    color: white;
    padding: 8px 15px;
    border-radius: 20px;
    font-size: 12px;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    box-shadow: 0 4px 15px rgba(255, 107, 107, 0.3);
}

/* Sales SVG styling */
.sales-svg-main {
    background: linear-gradient(135deg, #3c55ab 0%, #0099CC 100%);
    border: 4px solid white;
}

.sales-svg-main img {
    filter: brightness(0) invert(1);
}

/* Price section */
.price-section {
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 10px;
    margin-top: 15px;
    padding: 15px;
    background: #f8f9fa;
    border-radius: 10px;
    flex-wrap: wrap;
}

.original-price {
    font-size: 16px;
    color: #999;
    text-decoration: line-through;
    font-weight: 500;
}

.sale-price {
    font-size: 24px;
    color: #3c55ab;
    font-weight: 700;
}

.discount-badge {
    background: linear-gradient(135deg, #4CAF50 0%, #45a049 100%);
    color: white;
    padding: 4px 8px;
    border-radius: 12px;
    font-size: 11px;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

/* Card content adjustments */
.sales-page-row .card-containe {
    flex-grow: 1;
    display: flex;
    flex-direction: column;
    justify-content: space-between;
}

.sales-page-row .services-card-sub-text {
    flex-grow: 1;
    display: flex;
    align-items: flex-start;
    margin-bottom: 10px;
}

/* Ensure consistent card heights */
.sales-page-row .col-xxl-4,
.sales-page-row .col-xl-4,
.sales-page-row .col-lg-4,
.sales-page-row .col-md-6 {
    display: flex;
    margin-bottom: 40px;
}

/* No sales message styling */
.no-sales-message {
    padding: 60px 20px;
    background: #f8f9fa;
    border-radius: 20px;
    margin-top: 50px;
}

.no-sales-message h3 {
    color: #333;
    font-size: 28px;
    font-weight: 600;
    margin: 20px 0 15px 0;
}

.no-sales-message p {
    color: #666;
    font-size: 16px;
    margin-bottom: 30px;
    max-width: 500px;
    margin-left: auto;
    margin-right: auto;
}

.no-sales-icon {
    margin-bottom: 20px;
}

/* Button styling */
.btn-quote {
    background: linear-gradient(135deg, #3c55ab 0%, #0099CC 100%);
    border: none;
    padding: 15px 30px;
    border-radius: 25px;
    color: white;
    font-weight: 600;
    text-decoration: none;
    display: inline-flex;
    align-items: center;
    gap: 10px;
    transition: all 0.3s ease;
}

.btn-quote:hover {
    transform: translateY(-2px);
    box-shadow: 0 10px 25px rgba(0, 194, 255, 0.3);
    color: white;
    text-decoration: none;
}

/* Responsive adjustments - matching service page */
@media (max-width: 768px) {
    .sales-page-row .cleaning-card-img-main {
        height: 220px;
    }

    .price-section {
        padding: 10px;
    }

    .sale-price {
        font-size: 20px;
    }

    .no-sales-message {
        padding: 40px 15px;
    }

    .no-sales-message h3 {
        font-size: 24px;
    }
}

@media (max-width: 576px) {
    .sales-page-row .cleaning-card-img-main {
        height: 180px;
    }

    .sales-page-row {
        gap: 30px 0;
    }

    .price-section {
        flex-direction: column;
        gap: 5px;
    }

    .no-sales-message {
        padding: 30px 10px;
    }
}

@media (max-width: 425px) {
    .sales-page-row .cleaning-card-img-main {
        height: 160px;
    }
}

/* Animation for sale badge */
@keyframes pulse-sale {
    0% {
        transform: scale(1);
    }
    50% {
        transform: scale(1.05);
    }
    100% {
        transform: scale(1);
    }
}

.sale-badge {
    animation: pulse-sale 2s infinite;
}
</style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/koushikkona/Documents/Projects/ses/resources/views/frontend/sales.blade.php ENDPATH**/ ?>